// NOTE: Cpanel call to get Host information is not working, static value is used for now.

// Redirect to login if not logged in
if (sessionStorage.getItem('isLoggedIn') !== 'true') {
  window.location.href = '../index.html'; // Adjust the path to the location of your login.html file
}

// Dummy data for created email accounts and selected domains; replace this with data from local storage
// Retrieve the stored email accounts from local storage
const createdEmailAccounts = JSON.parse(localStorage.getItem('createdEmailAccounts')) || [];
const selectedDomains = JSON.parse(localStorage.getItem('selectedDomains')) || [];

// Update the completion text
document.getElementById('completionText').innerText = `SPF, DMARC, and Instantly Tracking Domain set for ${selectedDomains.length} domains. ${createdEmailAccounts.length} email accounts created.`;


 // Function to export created email accounts to CSV
async function exportToCSV() {
  const csvRows = [];
  const headers = ['Email', 'First Name', 'Last Name', 'IMAP Username', 'IMAP Password', 'IMAP Host', 'IMAP Port', 'SMTP Username', 'SMTP Password', 'SMTP Host', 'SMTP Port', 'Daily Limit', 'Warmup Enabled', 'Warmup Limit', 'Warmup Increment'];
  csvRows.push(headers.join(','));

  // Fetch client settings for each email account and construct CSV rows
  for (const account of createdEmailAccounts) {
    try {
      console.log('Retrieving settings for:', account.email); // Add this line to log the email address
      const settings = await getClientSettings(account.email);
      const imapHost = settings.result.data.inbox_host;
      const smtpHost = settings.result.data.smtp_host;
      const row = [
        account.email, // Verified Email
        account.firstName,
        account.lastName,
        account.email, // IMAP Username (same as verified email)
        account.password,
        "node510.namehero.net", // IMAP Host - Not from cPanel
        '993', // IMAP Port for SSL
        account.email, // SMTP Username (same as verified email)
        account.password,
        "node510.namehero.net", // SMTP Host - Not from cPanel
        '465', // SMTP Port for SSL
        '30', // Daily Limit
        'true', // Warmup Enabled
        '20', // Warmup Limit
        '2' // Warmup Increment
      ];
      csvRows.push(row.join(','));
    } catch (error) {
      console.error(`Failed to retrieve client settings for the email: ${account.email}`, error);
      // Handle the error appropriately - perhaps push a row with default values or skip the row entirely
    }
  }

  const csvData = csvRows.join('\n');
  const blob = new Blob([csvData], { type: 'text/csv' });
  const url = window.URL.createObjectURL(blob);
  const a = document.createElement('a');
  a.setAttribute('hidden', '');
  a.setAttribute('href', url);
  a.setAttribute('download', 'email_accounts.csv');
  document.body.appendChild(a);
  a.click();
  document.body.removeChild(a);
}

// Listen for Export for Instantly button click
document.getElementById('exportButton').addEventListener('click', () => {
  exportToCSV().catch(error => {
    console.error('Error exporting to CSV:', error);
  });
});

// Function to export to SmartLead format
async function exportToSmartLead() {
  const csvRows = [];
  const headers = ['from_name', 'from_email', 'user_name', 'password', 'smtp_host', 'smtp_port', 'imap_host', 'imap_port', 'max_email_per_day', 'custom_tracking_url', 'warmup_enabled', 'total_warmup_per_day', 'daily_rampup', 'reply_rate_percentage', 'bcc', 'signature', 'different_reply_to_address', 'imap_user_name', 'imap_password'];
  csvRows.push(headers.join(','));

  for (const account of createdEmailAccounts) {
    const domain = account.email.split('@')[1]; // Extract domain from email
    const row = [
      account.firstName + ' ' + account.lastName,
      account.email,
      account.email,
      account.password,
      "node510.namehero.net",
      '465',
      "node510.namehero.net",
      '993',
      '30',
      'smart' + domain,
      'true',
      '30',
      '2',
      '30',
      '',
      '',
      '',
      account.email,
      account.password
    ];
    csvRows.push(row.join(','));
  }

  const csvData = csvRows.join('\n');
  const blob = new Blob([csvData], { type: 'text/csv' });
  const url = window.URL.createObjectURL(blob);
  const a = document.createElement('a');
  a.setAttribute('hidden', '');
  a.setAttribute('href', url);
  a.setAttribute('download', 'smartlead_accounts.csv');
  document.body.appendChild(a);
  a.click();
  document.body.removeChild(a);
}

// Listen for Export for SmartLead click
document.getElementById('exportSmartLeadButton').addEventListener('click', () => {
  exportToSmartLead().catch(error => {
    console.error('Error exporting to SmartLead:', error);
  });
});

// Initialize Google API Client
function initClient() {
  gapi.client.init({
      'apiKey': 'AIzaSyAmkZCNzmyaIlhNpvZHjJcXWL1fJh4rvOM',
      'discoveryDocs': ['https://sheets.googleapis.com/$discovery/rest?version=v4'],
  }).then(function () {
      sendDataToGoogleSheets(); // Call function to send data after client is initialized
  });
}

// Load the Google API Client
function handleClientLoad() {
  gapi.load('client', initClient);
}

// Set up the window load event listener
window.onload = handleClientLoad;

// Function to prepare data for Google Sheets
function prepareDataForSheets() {
  let today = new Date().toISOString().split('T')[0]; // Gets current date in YYYY-MM-DD format
  let dataToExport = [
    ["Date", "First Name", "Last Name", "Email", "Password", "Host"] // Updated headers with 'Date'
  ];
  
  dataToExport.push([today, "", "", "", "", ""]); // Adds the current date as the first row
  
  createdEmailAccounts.forEach(account => {
    dataToExport.push([
      "", // Leave the date column empty for these rows
      account.firstName,
      account.lastName,
      account.email,
      account.password,
      "node510.namehero.net"
    ]);
  });

  return dataToExport;
}

// Function to send data to Google Sheets
function sendDataToGoogleSheets() {
  const data = prepareDataForSheets();
  appendDataToSheet(data);
}

// Function to append data to Google Sheets
function appendDataToSheet(data) {
  var params = {
      spreadsheetId: '1tbga5o2drGleRMRxFF32MfjIPTnP-50HI6A2LA_WHpI',
      range: 'Full Export', 
      valueInputOption: 'USER_ENTERED', 
  };

  var valueRangeBody = {
      "values": data
  };

  var request = gapi.client.sheets.spreadsheets.values.append(params, valueRangeBody);
  request.then(function(response) {
      console.log(response);
  }, function(reason) {
      console.error('error: ' + reason.result.error.message);
  });
}
