// Redirect to login if not logged in
if (sessionStorage.getItem('isLoggedIn') !== 'true') {
  window.location.href = '../index.html'; // Adjust the path to the location of your login.html file
}

// Get the selected domains from local storage
const selectedDomains = JSON.parse(localStorage.getItem('selectedDomains')) || [];

// Populate the div with redirect fields
document.addEventListener('DOMContentLoaded', function() {
  const redirectDomainsTable = document.getElementById('redirectDomains');
  // Create the table header
  const thead = document.createElement('thead');
  const headerRow = document.createElement('tr');

  // Create and append the 'Selected Domains' header cell
  const domainHeaderCell = document.createElement('th');
  domainHeaderCell.textContent = 'Selected Domains';
  domainHeaderCell.style.textAlign = 'center';
  headerRow.appendChild(domainHeaderCell);

  // Create and append the 'Redirect To' header cell
  const redirectToHeaderCell = document.createElement('th');
  redirectToHeaderCell.textContent = 'Redirect To';
  redirectToHeaderCell.colSpan = '2'; // Span across two columns if you have a status column
  redirectToHeaderCell.style.textAlign = 'center';
  headerRow.appendChild(redirectToHeaderCell);

  // Append the header row to the table header
  thead.appendChild(headerRow);

  // Append the table header to the table
  redirectDomainsTable.appendChild(thead);

  // Create the table body
  const tbody = document.createElement('tbody');

  selectedDomains.forEach(domain => {
    // Create table row
    const row = document.createElement('tr');

    // Create table cell for label
    const labelCell = document.createElement('td');
    labelCell.style.textAlign = 'left';
    labelCell.style.border = 'none';
    labelCell.innerHTML = `<label for="${domain}Redirect">${domain}</label>`;
    row.appendChild(labelCell);

    // Create table cell for input
    const inputCell = document.createElement('td');
    inputCell.style.textAlign = 'left';
    inputCell.style.border = 'none';
    inputCell.innerHTML = `<input type="text" id="${domain}Redirect" name="${domain}Redirect">`;
    row.appendChild(inputCell);

    // Create table cell for status
    const statusCell = document.createElement('td');
    statusCell.style.textAlign = 'left';
    statusCell.style.border = 'none';
    statusCell.innerHTML = `<span id="${domain}Status"></span>`;
    row.appendChild(statusCell);

    // Append the row to the table
    redirectDomainsTable.appendChild(row);
  });
});

// Function to get current domain redirect
async function getCurrentRedirect(domain) {
  const endpoint = 'cpanel?cpanel_jsonapi_apiversion=3&cpanel_jsonapi_module=Mime&cpanel_jsonapi_func=get_redirect';
  const params = { domain: domain };
  const response = await makeApiRequest(endpoint, params);
  console.log(`Current redirect for ${domain}:`, response);
  return response;
}

// Function to normalize URLs for comparison
function normalizeUrl(url) {
  return url.replace(/^https?:\/\//, '').replace(/^www\./, '').replace(/\/$/, '');
}

// Function to set domain redirects using cPanel API
async function setDomainRedirects(domain, redirectUrl) {
  const endpoint = 'cpanel?cpanel_jsonapi_apiversion=3&cpanel_jsonapi_module=Mime&cpanel_jsonapi_func=add_redirect';
  const params = {
    domain: domain,
    redirect: redirectUrl,
    redirect_wildcard: 0,
    redirect_www: 0,
    src: '/',
    type: 'permanent'
  };
  // Display loading animation
  const statusElement = document.getElementById(`${domain}Status`);
  statusElement.innerHTML = '<div class="loading-animation"></div>'; // Add loading animation

  const response = await makeApiRequest(endpoint, params);
  console.log(`Setting redirect for ${domain} to ${redirectUrl}`);
  
  // Get current redirect and compare
  const currentRedirect = await getCurrentRedirect(domain);
  if (normalizeUrl(currentRedirect.result.data.url) === normalizeUrl(redirectUrl)) {
    console.log(`Redirect for ${domain} matches the set URL.`);
    statusElement.innerHTML = '<span class="success-symbol">✅</span>'; // Unicode for checkmark
  } else {
    console.log(`Redirect for ${domain} does not match the set URL.`);
    statusElement.innerHTML = '<span class="error-symbol">❌</span>'; // Unicode for X
  }
}


// Function to handle setting redirects
async function handleSetRedirects(event) {
  event.preventDefault();
  
  for (const domain of selectedDomains) {
    const redirectUrl = document.getElementById(`${domain}Redirect`).value;
    if (redirectUrl) {
      try {
        await setDomainRedirects(domain, redirectUrl);
      } catch (error) {
        console.error(`Error setting redirect for ${domain}:`, error);
        const statusElement = document.getElementById(`${domain}Status`);
        statusElement.innerHTML = '<span class="error-symbol">❌</span>'; // Unicode for X
      }
    }
  }
}
// Get the form element and buttons
const form = document.getElementById('redirectForm');
const setRedirectsButton = document.getElementById('setRedirectsButton');
const nextButton = document.getElementById('nextButton');

// Listen for form submission and button clicks
form.addEventListener('submit', handleNext);
setRedirectsButton.addEventListener('click', handleSetRedirects);


// Function to handle the "Next" button
function handleNext(event) {
  event.preventDefault();
  window.location.href = 'create_email_accounts.html';
}


