// Redirect to login if not logged in
if (sessionStorage.getItem('isLoggedIn') !== 'true') {
  window.location.href = '../index.html'; // Adjust the path to the location of your login.html file
}


// Redirect to login if not logged in
if (sessionStorage.getItem('isLoggedIn') !== 'true') {
  window.location.href = '../index.html'; // Adjust the path to the location of your login.html file
}

document.addEventListener('DOMContentLoaded', function() {
  populateDomainList();
  document.getElementById('domainSearch').addEventListener('keyup', filterDomains);
});

async function populateDomainList() {
  try {
    const domainData = await listAddonDomains();
    if (!domainData || !Array.isArray(domainData)) {
      throw new Error('Invalid domain data received from API.');
    }
  // Sort domainData alphabetically
  domainData.sort((a, b) => a.localeCompare(b));
    const domainListDiv = document.getElementById('domainList');
    domainData.forEach(domain => {
      const checkbox = document.createElement('input');
      checkbox.type = 'checkbox';
      checkbox.id = domain;
      checkbox.name = 'domains';
      checkbox.value = domain;

      const label = document.createElement('label');
      label.htmlFor = domain;
      label.appendChild(document.createTextNode(domain));

      const br = document.createElement('br');

      domainListDiv.appendChild(checkbox);
      domainListDiv.appendChild(label);
      domainListDiv.appendChild(br);
    });
  } catch (error) {
    console.error('Error populating domain list:', error);
  }
}
// Function to search domains
function filterDomains() {
  const searchInput = document.getElementById('domainSearch').value.toLowerCase();
  const domainListDiv = document.getElementById('domainList');
  const domainElements = domainListDiv.children; // Get all children of the domainListDiv

  let domainGroups = [];
  for (let i = 0; i < domainElements.length; i += 3) { // Assuming each domain has a checkbox, label, and <br>
    let domainLabel = domainElements[i+1];
    let domainName = domainLabel.textContent || domainLabel.innerText;

    domainGroups.push({ checkbox: domainElements[i], label: domainLabel, br: domainElements[i+2], name: domainName });
  }

  // Clear the current list
  domainListDiv.innerHTML = '';

  // Filter and reorder domains
  domainGroups.forEach(group => {
    if (group.name.toLowerCase().indexOf(searchInput) > -1) {
      group.checkbox.style.display = '';
      group.label.style.display = '';
      group.br.style.display = '';
      domainListDiv.appendChild(group.checkbox);
      domainListDiv.appendChild(group.label);
      domainListDiv.appendChild(group.br);
    } else {
      group.checkbox.style.display = 'none';
      group.label.style.display = 'none';
      group.br.style.display = 'none';
    }
  });
}



// Function to initiate zone records
async function initiateZoneRecords() {
  const checkboxes = document.querySelectorAll('input[name="domains"]:checked');
  const selectedDomains = Array.from(checkboxes).map(checkbox => checkbox.value);

  for (const domain of selectedDomains) {
    const labelElement = document.getElementById(domain).nextSibling;
    labelElement.innerHTML += ' 🔄'; // Add loading sign

    let serial;
    try {
      serial = await fetchDnsSerialNumber(domain); // Fetch serial number for each domain
      console.log(`Fetched serial for ${domain}: ${serial}`);

      const cnameResponse = await setCnameRecord(domain, serial);
      serial = cnameResponse.result.data.new_serial;

      const additionalCnameResponse = await setAdditionalCnameRecord(domain, serial);
      serial = additionalCnameResponse.result.data.new_serial;

      const dmarcResponse = await setDmarcRecord(domain, serial);
      serial = dmarcResponse.result.data.new_serial;

      try {
        const lineIndex = await findTxtRecordLineIndex(domain);
        const deleteResponse = await deleteTxtRecord(domain, lineIndex, serial);
        serial = deleteResponse.result.data.new_serial; // Update serial after delete
      } catch (error) {
        console.log("No matching TXT record found for deletion. Skipping delete.");
      }
    } catch (error) {
      console.log(`Error setting zone records for ${domain}:`, error);
    }

    // Always attempt to add a new TXT record, regardless of the outcome of the above operations
    await addNewTxtRecord(domain, serial);
    labelElement.innerHTML = labelElement.innerHTML.replace('🔄', '✅'); // Replace loading sign with checkmark
  }
}


const form = document.getElementById('domainForm');

form.addEventListener('submit', function(event) {
  event.preventDefault();

  const checkboxes = document.querySelectorAll('input[name="domains"]:checked');
  const selectedDomains = Array.from(checkboxes).map(checkbox => checkbox.value);

  localStorage.setItem('selectedDomains', JSON.stringify(selectedDomains));

  window.location.href = 'domain_redirects.html';
});
