// Redirect to login if not logged in
if (sessionStorage.getItem('isLoggedIn') !== 'true') {
  window.location.href = '../index.html'; // Adjust the path to the location of your login.html file
}

// Get data from local storage
const createdEmailAccounts = JSON.parse(localStorage.getItem('createdEmailAccounts')) || [];

// Get the tbody element
const emailForwardingTbody = document.getElementById('emailForwarding');

// Function to add a new email forwarding row
function addEmailForwarding(emailAccount) {
  console.log("Adding email forwarding for:", emailAccount); 
  const forwardingRow = document.createElement('tr');
  forwardingRow.innerHTML = `
    <td>${emailAccount.email}</td>
    <td><input type="text" name="forwardTo"><span class="status"></span></td>
  `;
  emailForwardingTbody.appendChild(forwardingRow);
}

// Add default email forwarding rows
createdEmailAccounts.forEach(emailAccount => {
  addEmailForwarding(emailAccount);
});

// Get the form element
const form = document.getElementById('forwardingForm');

// Listen for Add Forwarders button click
document.getElementById('addForwardersButton').addEventListener('click', async function() {
  const forwardingRows = emailForwardingTbody.querySelectorAll('tr');
  for (const row of forwardingRows) {
    const emailAccount = row.cells[0].innerText;
    const forwardTo = row.querySelector('input[name="forwardTo"]').value;
    const [emailName, domain] = emailAccount.split('@');
    const statusSpan = row.querySelector('.status');
    statusSpan.textContent = ' 🔄';  // Add loading sign
    
    try {
      const response = await addEmailForwarder(domain, emailName, forwardTo);
      console.log(`Email forwarder added: ${emailAccount} -> ${forwardTo}`, response);
      
      // Verify if the forwarder has been set up correctly
      const forwardersResponse = await listEmailForwarders(domain, `regex=${emailName}`);  // Added regex filter
      const forwarders = forwardersResponse.result.data;
      const isForwarderSet = forwarders.some(fwd => fwd.forward === forwardTo && fwd.dest === emailAccount);  // Corrected the comparison
      
      if (isForwarderSet) {
        console.log('Verification passed');  // Log for debugging
        statusSpan.innerHTML = statusSpan.innerHTML.replace('🔄', '✅');  // Replace loading sign with checkmark
      } else {
        console.log('Verification failed');  // Log for debugging
        statusSpan.innerHTML = statusSpan.innerHTML.replace('🔄', '❌');  // Replace loading sign with 'X'
      }
      
    } catch (error) {
      console.error(`Error adding email forwarder: ${emailAccount} -> ${forwardTo}`, error);
      statusSpan.innerHTML = statusSpan.innerHTML.replace('🔄', '❌');  // Replace loading sign with 'X'
    }
  }
});

// Listen for form submission
form.addEventListener('submit', function(event) {
  event.preventDefault();
  window.location.href = 'completion.html';
});