// Redirect to login if not logged in
if (sessionStorage.getItem('isLoggedIn') !== 'true') {
  window.location.href = '../index.html'; // Adjust the path to the location of your login.html file
}


// Get the selected domains from local storage
const selectedDomains = JSON.parse(localStorage.getItem('selectedDomains')) || [];

// Get the tbody element where email account rows will be added
const emailAccountsTbody = document.getElementById('emailAccounts');

// Utility function to delay execution for a set amount of time
function delay(time) {
  return new Promise(resolve => setTimeout(resolve, time));
}

// Function to generate a strong password
function generateStrongPassword() {
  const charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+~";
  let password = "";
  for (let i = 0; i < 12; i++) {
    password += charset[Math.floor(Math.random() * charset.length)];
  }
  return password;
}

// Function to add a new email account row
function addEmailAccount(domain) {
  const emailRow = document.createElement('tr');
  emailRow.innerHTML = `
    <td><input type="text" name="emailName" class="validate"></td>
    <td>@</td>
    <td>
      <select name="domain" class="validate">
        ${selectedDomains.map(d => `<option value="${d}" ${d === domain ? 'selected' : ''}>${d}</option>`).join('')}
      </select>
    </td>
    <td><input type="text" name="firstName" class="validate"></td>
    <td><input type="text" name="lastName" class="validate"></td>
    <td><input type="password" name="password" value="${generateStrongPassword()}" class="validate"><span class="eye">&#128065;</span></td>
    <td><button type="button" class="generatePassword">Generate</button></td>
    <td><button type="button" class="removeEmailButton">X</button></td>
  `;
  emailAccountsTbody.appendChild(emailRow);
}
// Event listener for DOMContentLoaded to ensure the DOM is fully loaded
document.addEventListener('DOMContentLoaded', (event) => {
  // Event listener for the "Add Email Account" button
  document.getElementById('addEmailButton').addEventListener('click', function() {
    const defaultDomain = selectedDomains[0]; // Default to the first domain in the array
    addEmailAccount(defaultDomain);
  });
});
  // Add default email accounts
  selectedDomains.forEach(domain => {
    for (let i = 0; i < 3; i++) {
      addEmailAccount(domain);
    }
  });

// Listen for Generate Password button clicks
emailAccountsTbody.addEventListener('click', function(event) {
  if (event.target.classList.contains('generatePassword')) {
    const passwordField = event.target.closest('tr').querySelector('input[name="password"]');
    passwordField.value = generateStrongPassword();
  }
});
// Function to create an email account using cPanel API
async function createEmailAccount(email, password, domain, quota = 0, sendWelcomeEmail = true) {
  const endpoint = 'cpanel?cpanel_jsonapi_apiversion=3&cpanel_jsonapi_module=Email&cpanel_jsonapi_func=add_pop';
  const params = {
    email,
    password,
    domain,
    quota,
    send_welcome_email: sendWelcomeEmail ? 1 : 0
  };
  console.log('Making API request to create email account:', endpoint, 'with params:', JSON.stringify(params));
  const response = await makeApiRequest(endpoint, params);
  console.log('Received API response for email account creation:', JSON.stringify(response));
  return response;
}

// Function to list email accounts using cPanel API
async function listEmailAccounts(domain) {
  const endpoint = 'cpanel?cpanel_jsonapi_apiversion=3&cpanel_jsonapi_module=Email&cpanel_jsonapi_func=list_pops';
  const params = { domain };
  console.log('Making API request to list email accounts:', endpoint, 'with params:', JSON.stringify(params));
  const response = await makeApiRequest(endpoint, params);
  console.log('Received API response for listing email accounts:', JSON.stringify(response));
  return response;
}

// Helper function to introduce a delay
function delay(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}

// Declare the array to store confirmed email accounts at the top level so it's accessible later
let confirmedEmailAccounts = [];

// Listen for Create Email Accounts button click
document.getElementById('createEmailAccountsButton').addEventListener('click', async function() {
  console.log('Button clicked to create email accounts');
  const emailRows = emailAccountsTbody.querySelectorAll('tr');

  for (const row of emailRows) {
    const emailName = row.querySelector('input[name="emailName"]').value;
    const domain = row.querySelector('select[name="domain"]').value;
    const password = row.querySelector('input[name="password"]').value;
    const email = `${emailName}@${domain}`;
    const loadingSymbolCell = document.createElement('td');
    loadingSymbolCell.className = 'loading-animation';
    row.appendChild(loadingSymbolCell);


    console.log(`Attempting to create email account: ${email}`);
    try {
      const response = await createEmailAccount(emailName, password, domain);
      console.log(`Email account creation response for ${email}:`, JSON.stringify(response));

      // Introduce a delay before verification
      console.log(`Waiting for 5 seconds before verifying the creation of email account: ${email}`);
      await delay(5000); // Delay for 5 seconds

      console.log(`Verifying the creation of email account: ${email}`);
      const verificationResponse = await listEmailAccounts(domain);
      const domainRegex = new RegExp(`@${domain.replace('.', '\\.')}$`); // Escape dot for regex
      const relevantEmails = verificationResponse.result.data.filter(account => domainRegex.test(account.email));

      console.log(`Listing email accounts for domain ${domain} to verify the creation of ${email}:`, relevantEmails);

      let isEmailCreated = false;
      if (relevantEmails && relevantEmails.length > 0) {
        console.log(`Starting detailed verification for ${email}`);
        for (const account of relevantEmails) { // Use relevantEmails here
          console.log(`Comparing created email '${email}' with account email '${account.email}' from the list.`);
          if (account.email === email) {
            console.log(`Verification success: '${email}' matches '${account.email}' in the account list.`);
            isEmailCreated = true;
            loadingSymbolCell.className = ''; // Remove the spinning animation class
            loadingSymbolCell.innerHTML = '<span class="success-symbol">✅</span>'; // Add checkmark
            // Add the confirmed email to the array
            confirmedEmailAccounts.push({
              email: account.email, // This is the confirmed email from the API
              domain,
              firstName: row.querySelector('input[name="firstName"]').value,
              lastName: row.querySelector('input[name="lastName"]').value,
              password: row.querySelector('input[name="password"]').value
            });
            break;
          } else {
            console.log(`Verification mismatch: '${email}' does not match '${account.email}' in the account list.`);
          }
        }
        if (!isEmailCreated) {
          console.log(`Verification failed: '${email}' was not found in the account list after creation.`);
          loadingSymbolCell.className = ''; // Remove the spinning animation class
          loadingSymbolCell.innerHTML = '<span class="error-symbol">❌</span>'; // Add cross
        }
      } else {
        console.log(`Verification failed: No email accounts returned from API for domain: ${domain}`);
        loadingSymbolCell.className = ''; // Remove the spinning animation class
        loadingSymbolCell.innerHTML = '<span class="error-symbol">❌</span>'; // Add cross
      }
    } catch (error) {
      console.log(`Error during the creation or verification of ${email}: ${error.message}`);
      loadingSymbolCell.className = ''; // Remove the spinning animation class
      loadingSymbolCell.innerHTML = '<span class="error-symbol">❌</span>'; // Add cross
      console.error(`Error details:`, error);
    }
  }
});

// Get the form element
const form = document.getElementById('emailForm');

// Listen for form submission
form.addEventListener('submit', function(event) {
  // Prevent default form submission
  event.preventDefault();

  let isValid = true;
  document.querySelectorAll('.validate').forEach(input => {
    if (input.value.length < 3) {
      input.classList.add('invalid');
      isValid = false;
    } else {
      input.classList.remove('invalid');
    }
  });

  // After the loop, store the confirmed emails in local storage
  if (isValid && confirmedEmailAccounts.length > 0) {
    localStorage.setItem('createdEmailAccounts', JSON.stringify(confirmedEmailAccounts));
    // Redirect to the next page
    window.location.href = 'email_forwarding.html';
  }
});

// Listen for eye symbol clicks to toggle password visibility
emailAccountsTbody.addEventListener('click', function(event) {
  if (event.target.classList.contains('eye')) {
    const passwordField = event.target.closest('tr').querySelector('input[name="password"]');
    passwordField.type = passwordField.type === 'password' ? 'text' : 'password';
  }
});

// Listen for Remove Email Account button clicks
emailAccountsTbody.addEventListener('click', function(event) {
  if (event.target.classList.contains('removeEmailButton')) {
    const emailRow = event.target.closest('tr');
    emailAccountsTbody.removeChild(emailRow);
  }
});

