// DOM elements 
const pageContent = document.getElementById('page-content');
const navLinks = document.querySelectorAll('.nav-link');

// Load page function
function loadPage(page) {

  // Make AJAX request
  $.get(page, function(data) {

    // Update DOM with new content
    pageContent.innerHTML = data;

    // Re-init any JS behavior for new page
    initPage();

  });

}

// Init first page
loadPage('pages/page1.html'); 

// Navigation click handlers
navLinks.forEach(link => {
  link.addEventListener('click', e => {
    e.preventDefault();
    
    // Load new page
    loadPage(link.getAttribute('href')); 
  });
});

// Page-specific init logic
function initPage() {
  // Any JS needed for page
}