<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');

// The cPanel API URL
$cPanelApiUrl = 'https://sparkstride.online:2083/json-api/';

// Collect data from the POST request
$requestData = json_decode(file_get_contents('php://input'), true);

if (is_array($requestData) && isset($requestData['endpoint'])) {
    $endpoint = $requestData['endpoint'];
    $params = isset($requestData['params']) ? $requestData['params'] : [];

    // Construct the query string from params
    $queryString = http_build_query($params);

    // cPanel API token and username
    $cPanelApiToken = 'OCFBKXYYDDHU6E4PDWW5U1P8LF4USIHY';
    $cPanelUsername = 'sparggzh';

    // Determine if a '?' is already present in the endpoint string
    $separator = strpos($endpoint, '?') === false ? '?' : '&';

    // The full URL to the cPanel API
    $url = $cPanelApiUrl . $endpoint . $separator . $queryString;

    // Initialize cURL session
    $ch = curl_init();

    // Set cURL options for a GET request
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: cpanel ' . $cPanelUsername . ':' . $cPanelApiToken,
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Execute cURL session
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        // If cURL encountered an error, log it
        $error_msg = curl_error($ch);
        error_log($error_msg); // This will log to your PHP error log
        echo json_encode(['error' => $error_msg]);
    } else {
        // Echo the response from the cPanel API
        echo $response;
    }

    // Close cURL session
    curl_close($ch);

} else {
    echo json_encode(['error' => 'No JSON data received or incorrect data format.']);
}
?>
