// NOTE: Cpanel call to get Host information is not working, static value is used for now.

// Redirect to login if not logged in
if (sessionStorage.getItem('isLoggedIn') !== 'true') {
  window.location.href = '../index.html'; // Adjust the path to the location of your login.html file
}

// Dummy data for created email accounts and selected domains; replace this with data from local storage
// Retrieve the stored email accounts from local storage
const createdEmailAccounts = JSON.parse(localStorage.getItem('createdEmailAccounts')) || [];
const selectedDomains = JSON.parse(localStorage.getItem('selectedDomains')) || [];

// Update the completion text
document.getElementById('completionText').innerText = `SPF, DMARC, and Instantly Tracking Domain set for ${selectedDomains.length} domains. ${createdEmailAccounts.length} email accounts created.`;


 // Function to export created email accounts to CSV
async function exportToCSV() {
  const csvRows = [];
  const headers = ['Email', 'First Name', 'Last Name', 'IMAP Username', 'IMAP Password', 'IMAP Host', 'IMAP Port', 'SMTP Username', 'SMTP Password', 'SMTP Host', 'SMTP Port', 'Daily Limit', 'Warmup Enabled', 'Warmup Limit', 'Warmup Increment'];
  csvRows.push(headers.join(','));

  // Fetch client settings for each email account and construct CSV rows
  for (const account of createdEmailAccounts) {
    try {
      console.log('Retrieving settings for:', account.email); // Add this line to log the email address
      const settings = await getClientSettings(account.email);
      const imapHost = settings.result.data.inbox_host;
      const smtpHost = settings.result.data.smtp_host;
      const row = [
        account.email, // Verified Email
        account.firstName,
        account.lastName,
        account.email, // IMAP Username (same as verified email)
        account.password,
        "node510.namehero.net", // IMAP Host - Not from cPanel
        '993', // IMAP Port for SSL
        account.email, // SMTP Username (same as verified email)
        account.password,
        "node510.namehero.net", // SMTP Host - Not from cPanel
        '465', // SMTP Port for SSL
        '30', // Daily Limit
        'true', // Warmup Enabled
        '20', // Warmup Limit
        '2' // Warmup Increment
      ];
      csvRows.push(row.join(','));
    } catch (error) {
      console.error(`Failed to retrieve client settings for the email: ${account.email}`, error);
      // Handle the error appropriately - perhaps push a row with default values or skip the row entirely
    }
  }

  const csvData = csvRows.join('\n');
  const blob = new Blob([csvData], { type: 'text/csv' });
  const url = window.URL.createObjectURL(blob);
  const a = document.createElement('a');
  a.setAttribute('hidden', '');
  a.setAttribute('href', url);
  a.setAttribute('download', 'email_accounts.csv');
  document.body.appendChild(a);
  a.click();
  document.body.removeChild(a);
}

// Listen for Export for Instantly button click
document.getElementById('exportButton').addEventListener('click', () => {
  exportToCSV().catch(error => {
    console.error('Error exporting to CSV:', error);
  });
});